/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxApplet
extends JApplet {
    private Container container;
    private JPanel controlPanel;
    private JPanel graphPanel;
    private JPanel sotonPanel;
    private JPanel boxPanel;
    private JPanel massPanel;
    private JPanel checkPanel;
    private JPanel radioPanel;
    private JSlider lengthSlider;
    private JSlider massSlider;
    private JLabel lengthLabel;
    private JLabel massLabel;
    private JCheckBox n1Check;
    private JCheckBox n2Check;
    private JCheckBox n3Check;
    private JCheckBox n4Check;
    private JCheckBox n5Check;
    private JCheckBox n6Check;
    private JRadioButton waveRadio;
    private JRadioButton probRadio;
    private BigDecimal boxLength;
    private BigDecimal mass;
    private EnergyLevel[] energyLevels;
    private WaveFunction[] waveLengths;
    private boolean[] selected;
    private boolean isProb;
    private double[] boxProportion;
    private double x;

    public void init() {
        int i;
        this.setSize(1025, 625);
        this.boxLength = new BigDecimal("2.50");
        this.mass = new BigDecimal("3.00");
        this.selected = new boolean[6];
        this.boxProportion = new double[101];
        this.x = 0.0;
        for (i = 0; i < 101; ++i) {
            this.boxProportion[i] = this.x;
            this.x += 0.01;
        }
        this.energyLevels = new EnergyLevel[6];
        this.waveLengths = new WaveFunction[6];
        for (i = 0; i < 6; ++i) {
            this.energyLevels[i] = new EnergyLevel(i + 1);
            this.waveLengths[i] = new WaveFunction(i + 1, this.boxProportion);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    BoxApplet.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI did not successfully complete");
        }
    }

    private void createGUI() {
        this.container = this.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.controlPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this.controlPanel.setBackground(Color.WHITE);
        this.boxPanel = new JPanel();
        this.boxPanel.setLayout(new BoxLayout(this.boxPanel, 1));
        this.boxPanel.setBackground(Color.WHITE);
        this.lengthLabel = new JLabel("Box Length/nm");
        this.lengthLabel.setAlignmentX(0.5f);
        this.boxPanel.add(this.lengthLabel);
        Hashtable<Integer, JLabel> boxLabels = new Hashtable<Integer, JLabel>();
        boxLabels.put(0, new JLabel("1"));
        boxLabels.put(50, new JLabel("2"));
        boxLabels.put(100, new JLabel("3"));
        boxLabels.put(150, new JLabel("4"));
        this.lengthSlider = new JSlider(0, 150, 75);
        this.lengthSlider.setAlignmentX(0.5f);
        this.lengthSlider.setBackground(Color.WHITE);
        this.lengthSlider.setMajorTickSpacing(50);
        this.lengthSlider.setMinorTickSpacing(10);
        this.lengthSlider.setPaintTicks(true);
        this.lengthSlider.setLabelTable(boxLabels);
        this.lengthSlider.setPaintLabels(true);
        this.boxPanel.add(this.lengthSlider);
        this.massPanel = new JPanel();
        this.massPanel.setLayout(new BoxLayout(this.massPanel, 1));
        this.massPanel.setBackground(Color.WHITE);
        this.massLabel = new JLabel("<html>Mass/10<sup>-30</sup>kg</html>");
        this.massPanel.add(this.massLabel);
        Hashtable<Integer, JLabel> massLabels = new Hashtable<Integer, JLabel>();
        massLabels.put(0, new JLabel("1"));
        massLabels.put(100, new JLabel("2"));
        massLabels.put(200, new JLabel("3"));
        massLabels.put(300, new JLabel("4"));
        massLabels.put(400, new JLabel("5"));
        this.massSlider = new JSlider(0, 400, 200);
        this.massSlider.setAlignmentX(0.5f);
        this.massSlider.setBackground(Color.WHITE);
        this.massSlider.setMajorTickSpacing(100);
        this.massSlider.setMinorTickSpacing(20);
        this.massSlider.setPaintTicks(true);
        this.massSlider.setLabelTable(massLabels);
        this.massSlider.setPaintLabels(true);
        this.massPanel.add(this.massSlider);
        this.checkPanel = new JPanel();
        this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 0));
        this.checkPanel.setBackground(Color.WHITE);
        this.n1Check = new JCheckBox("n = 1");
        this.n1Check.setForeground(Color.BLUE);
        this.n1Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n1Check);
        this.n2Check = new JCheckBox("n = 2");
        this.n2Check.setForeground(new Color(175, 3, 255));
        this.n2Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n2Check);
        this.n3Check = new JCheckBox("n = 3");
        this.n3Check.setForeground(Color.ORANGE);
        this.n3Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n3Check);
        this.n4Check = new JCheckBox("n = 4");
        this.n4Check.setForeground(Color.CYAN);
        this.n4Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n4Check);
        this.n5Check = new JCheckBox("n = 5");
        this.n5Check.setForeground(Color.RED);
        this.n5Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n5Check);
        this.n6Check = new JCheckBox("n = 6");
        this.n6Check.setForeground(Color.GREEN);
        this.n6Check.setBackground(Color.WHITE);
        this.checkPanel.add(this.n6Check);
        this.radioPanel = new JPanel();
        this.radioPanel.setLayout(new BoxLayout(this.radioPanel, 0));
        this.radioPanel.setBackground(Color.WHITE);
        this.waveRadio = new JRadioButton("Wavefunction", true);
        this.waveRadio.setBackground(Color.WHITE);
        this.probRadio = new JRadioButton("Probability Density", false);
        this.probRadio.setBackground(Color.WHITE);
        ButtonGroup group = new ButtonGroup();
        group.add(this.waveRadio);
        group.add(this.probRadio);
        this.radioPanel.add(this.waveRadio);
        this.radioPanel.add(this.probRadio);
        this.controlPanel.add(this.boxPanel);
        this.controlPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        this.controlPanel.add(this.massPanel);
        this.controlPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        this.controlPanel.add(this.checkPanel);
        this.controlPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        this.controlPanel.add(this.radioPanel);
        this.controlPanel.add(Box.createRigidArea(new Dimension(80, 0)));
        this.graphPanel = new JPanel();
        this.graphPanel.setBackground(Color.WHITE);
        ClassLoader cldr = this.getClass().getClassLoader();
        URL imageURL = cldr.getResource("image/logosmall.jpg");
        JLabel logoLabel = new JLabel();
        ImageIcon img = new ImageIcon(imageURL);
        logoLabel.setIcon(img);
        JLabel namesLabel = new JLabel("David Read | Malcolm Levitt | Richard Gillams | Christopher Asquith | William Fyson");
        namesLabel.setFont(new Font("sanserif", 0, 10));
        namesLabel.setSize(100, 10);
        this.sotonPanel = new JPanel();
        this.sotonPanel.setBackground(Color.WHITE);
        this.sotonPanel.setLayout(new FlowLayout(0));
        this.sotonPanel.add(logoLabel);
        this.sotonPanel.add(namesLabel);
        SliderHandler sliderHandler = new SliderHandler();
        this.lengthSlider.addChangeListener(sliderHandler);
        this.massSlider.addChangeListener(sliderHandler);
        CheckHandler checkHandler = new CheckHandler();
        this.n1Check.addItemListener(checkHandler);
        this.n2Check.addItemListener(checkHandler);
        this.n3Check.addItemListener(checkHandler);
        this.n4Check.addItemListener(checkHandler);
        this.n5Check.addItemListener(checkHandler);
        this.n6Check.addItemListener(checkHandler);
        this.n1Check.setSelected(true);
        RadioHandler radioHandler = new RadioHandler();
        this.waveRadio.addActionListener(radioHandler);
        this.probRadio.addActionListener(radioHandler);
        this.container.add((Component)this.controlPanel, "North");
        this.container.add((Component)this.graphPanel, "Center");
        this.container.add((Component)this.sotonPanel, "South");
    }

    public void paint(Graphics g) {
        int i;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)this.graphPanel.getGraphics();
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(62, 10, 13, 450);
        g2.fillRect((int)(this.boxLength.setScale(2, 4).doubleValue() * 100.0 + 79.0), 10, 13, 450);
        g2.setColor(Color.DARK_GRAY);
        g2.fillRect(75, 10, 2, 450);
        g2.fillRect((int)(this.boxLength.setScale(2, 4).doubleValue() * 100.0 + 77.0), 10, 2, 450);
        g2.setColor(Color.BLACK);
        g2.fillRect(60, 10, 2, 460);
        g2.fillRect(50, 460, 442, 2);
        g2.drawLine(492, 460, 482, 455);
        g2.drawLine(492, 460, 482, 456);
        g2.drawLine(492, 461, 482, 466);
        g2.drawLine(492, 461, 482, 467);
        g2.drawLine(60, 10, 55, 20);
        g2.drawLine(60, 10, 56, 20);
        g2.drawLine(61, 10, 66, 20);
        g2.drawLine(61, 10, 67, 20);
        g2.drawLine(77, 460, 77, 470);
        g2.drawString("0.0", 69, 480);
        g2.drawLine(127, 460, 127, 470);
        g2.drawString("0.5", 119, 480);
        g2.drawLine(177, 460, 177, 470);
        g2.drawString("1.0", 169, 480);
        g2.drawLine(227, 460, 227, 470);
        g2.drawString("1.5", 219, 480);
        g2.drawLine(277, 460, 277, 470);
        g2.drawString("2.0", 269, 480);
        g2.drawLine(327, 460, 327, 470);
        g2.drawString("2.5", 319, 480);
        g2.drawLine(377, 460, 377, 470);
        g2.drawString("3.0", 369, 480);
        g2.drawLine(427, 460, 427, 470);
        g2.drawString("3.5", 419, 480);
        g2.drawLine(477, 460, 477, 470);
        g2.drawString("4.0", 469, 480);
        g2.drawLine(50, 420, 60, 420);
        g2.drawLine(50, 380, 60, 380);
        g2.drawLine(50, 340, 60, 340);
        g2.drawLine(50, 300, 60, 300);
        g2.drawLine(50, 260, 60, 260);
        g2.drawLine(50, 220, 60, 220);
        g2.drawLine(50, 180, 60, 180);
        g2.drawLine(50, 140, 60, 140);
        g2.drawLine(50, 100, 60, 100);
        g2.drawLine(50, 60, 60, 60);
        g2.drawString("Energy", 15, 30);
        g2.drawString("Box Length/nm", 235, 495);
        for (i = 0; i < 6; ++i) {
            this.energyLevels[i].draw(this.graphPanel.getGraphics(), this.boxLength.setScale(2, 4).doubleValue(), this.mass.setScale(2, 4).doubleValue());
        }
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(570, 10, 13, 450);
        g2.fillRect((int)(this.boxLength.setScale(2, 4).doubleValue() * 100.0 + 587.0), 10, 13, 450);
        g2.setColor(Color.DARK_GRAY);
        g2.fillRect(583, 10, 2, 450);
        g2.fillRect((int)(this.boxLength.setScale(2, 4).doubleValue() * 100.0 + 585.0), 10, 2, 450);
        g2.setColor(Color.BLACK);
        g2.fillRect(568, 10, 2, 460);
        g2.fillRect(560, 460, 442, 2);
        g2.drawLine(1000, 460, 990, 455);
        g2.drawLine(1000, 460, 990, 456);
        g2.drawLine(1000, 461, 990, 466);
        g2.drawLine(1000, 461, 990, 467);
        g2.drawLine(568, 10, 563, 20);
        g2.drawLine(568, 10, 564, 20);
        g2.drawLine(569, 10, 574, 20);
        g2.drawLine(569, 10, 575, 20);
        g2.drawLine(585, 460, 585, 470);
        g2.drawString("0.0", 577, 480);
        g2.drawLine(635, 460, 635, 470);
        g2.drawString("0.5", 627, 480);
        g2.drawLine(685, 460, 685, 470);
        g2.drawString("1.0", 677, 480);
        g2.drawLine(735, 460, 735, 470);
        g2.drawString("1.5", 727, 480);
        g2.drawLine(785, 460, 785, 470);
        g2.drawString("2.0", 777, 480);
        g2.drawLine(835, 460, 835, 470);
        g2.drawString("2.5", 827, 480);
        g2.drawLine(885, 460, 885, 470);
        g2.drawString("3.0", 877, 480);
        g2.drawLine(935, 460, 935, 470);
        g2.drawString("3.5", 927, 480);
        g2.drawLine(985, 460, 985, 470);
        g2.drawString("4.0", 977, 480);
        g2.drawString("Box Length/nm", 735, 495);
        g2.fillRect(560, 225, 440, 2);
        g2.drawString("0.0", 540, 230);
        g2.drawLine(558, 200, 568, 200);
        g2.drawLine(558, 175, 568, 175);
        g2.drawLine(558, 150, 568, 150);
        g2.drawLine(558, 125, 568, 125);
        g2.drawLine(558, 100, 568, 100);
        g2.drawLine(558, 75, 568, 75);
        g2.drawLine(558, 50, 568, 50);
        g2.drawLine(558, 250, 568, 250);
        g2.drawLine(558, 275, 568, 275);
        g2.drawLine(558, 300, 568, 300);
        g2.drawLine(558, 325, 568, 325);
        g2.drawLine(558, 350, 568, 350);
        g2.drawLine(558, 375, 568, 375);
        g2.drawLine(558, 400, 568, 400);
        if (!this.isProb) {
            g2.drawString("Wavefunction", 493, 30);
            for (i = 0; i < 6; ++i) {
                if (!this.selected[i]) continue;
                this.waveLengths[i].draw(this.graphPanel.getGraphics(), this.boxLength.setScale(2, 4).doubleValue(), this.mass.setScale(2, 4).doubleValue(), this.energyLevels[i].getEnergy());
            }
        } else {
            g2.drawString("Probability", 500, 30);
            for (i = 0; i < 6; ++i) {
                if (!this.selected[i]) continue;
                this.waveLengths[i].drawSquare(this.graphPanel.getGraphics(), this.boxLength.setScale(2, 4).doubleValue(), this.mass.setScale(2, 4).doubleValue(), this.energyLevels[i].getEnergy());
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    private class RadioHandler
    implements ActionListener {
        private RadioHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BoxApplet.this.waveRadio) {
                BoxApplet.this.isProb = false;
                BoxApplet.this.repaint();
            } else if (e.getSource() == BoxApplet.this.probRadio) {
                BoxApplet.this.isProb = true;
                BoxApplet.this.repaint();
            }
        }
    }

    private class CheckHandler
    implements ItemListener {
        private CheckHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == BoxApplet.this.n1Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[0] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n2Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[1] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n3Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[2] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n4Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[3] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n5Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[4] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n6Check && e.getStateChange() == 1) {
                ((BoxApplet)BoxApplet.this).selected[5] = true;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n1Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[0] = false;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n2Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[1] = false;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n3Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[2] = false;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n4Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[3] = false;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n5Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[4] = false;
                BoxApplet.this.repaint();
            } else if (source == BoxApplet.this.n6Check && e.getStateChange() == 2) {
                ((BoxApplet)BoxApplet.this).selected[5] = false;
                BoxApplet.this.repaint();
            }
        }
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == BoxApplet.this.lengthSlider) {
                BigDecimal temp1 = new BigDecimal(Integer.toString(BoxApplet.this.lengthSlider.getValue()));
                temp1 = temp1.multiply(new BigDecimal("0.02"));
                BoxApplet.this.boxLength = temp1.add(BigDecimal.ONE);
                BoxApplet.this.repaint();
            }
            if (e.getSource() == BoxApplet.this.massSlider) {
                BigDecimal temp2 = new BigDecimal(Integer.toString(BoxApplet.this.massSlider.getValue()));
                temp2 = temp2.multiply(new BigDecimal("0.01"));
                BoxApplet.this.mass = temp2.add(BigDecimal.ONE);
                BoxApplet.this.repaint();
            }
        }
    }
}

