/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class EnergyLevel {
    private int n;
    private double energy;
    private Color col;
    final double H = 6.62608E-34;

    public EnergyLevel(int n) {
        this.n = n;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void draw(Graphics g, Double length, Double mass) {
        double firstpart = Math.pow(this.n, 2.0) * Math.pow(6.62608E-34, 2.0);
        double secondpart = 8.0 * (mass * 1.0E-27) * Math.pow(length, 2.0);
        this.energy = firstpart / secondpart;
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(1.0, 0.1);
        switch (this.n) {
            case 1: {
                this.col = Color.BLUE;
                break;
            }
            case 2: {
                this.col = new Color(175, 3, 255);
                break;
            }
            case 3: {
                this.col = Color.ORANGE;
                break;
            }
            case 4: {
                this.col = Color.CYAN;
                break;
            }
            case 5: {
                this.col = Color.RED;
                break;
            }
            case 6: {
                this.col = Color.GREEN;
            }
        }
        g2.setColor(this.col);
        if (4600.0 - this.energy * 1.0E43 >= 100.0) {
            g2.drawLine(77, (int)(4600.0 - this.energy * 1.0E43), (int)(length * 100.0 + 76.0), (int)(4600.0 - this.energy * 1.0E43));
            g2.drawLine(77, (int)(4600.0 - this.energy * 1.0E43) + 10, (int)(length * 100.0 + 76.0), (int)(4600.0 - this.energy * 1.0E43) + 10);
        }
    }
}

