/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class WaveFunction {
    private double[] boxProportion;
    private double[] distance;
    private double[] wavelength;
    private int n;
    private Color col;
    final double H = 6.62608E-34;
    final double CORRECTION = 1.0E41;
    final double PROBCORRECTION = 1.0E20;

    public WaveFunction(int n, double[] boxProportion) {
        this.n = n;
        this.boxProportion = boxProportion;
    }

    public void draw(Graphics g, Double length, Double mass, double energy) {
        this.distance = new double[101];
        for (int i = 0; i < 101; ++i) {
            this.distance[i] = this.boxProportion[i] * length;
        }
        this.wavelength = new double[101];
        double firstpart = Math.pow(2.0 / length, 0.5);
        double secondpart = (double)this.n * Math.PI / length;
        for (int i = 0; i < 101; ++i) {
            double thirdpart = secondpart * this.distance[i];
            thirdpart = Math.sin(thirdpart);
            thirdpart /= 1.0E41;
            this.wavelength[i] = thirdpart = firstpart * thirdpart;
            this.distance[i] = this.distance[i] * 100.0;
            this.wavelength[i] = this.wavelength[i] * 1.0E44;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(1.0, 0.1);
        switch (this.n) {
            case 1: {
                this.col = Color.BLUE;
                break;
            }
            case 2: {
                this.col = new Color(175, 3, 255);
                break;
            }
            case 3: {
                this.col = Color.ORANGE;
                break;
            }
            case 4: {
                this.col = Color.CYAN;
                break;
            }
            case 5: {
                this.col = Color.RED;
                break;
            }
            case 6: {
                this.col = Color.GREEN;
            }
        }
        g2.setColor(this.col);
        for (int i = 0; i < 100; ++i) {
            g2.drawLine((int)this.distance[i] + 585, (int)(2250.0 - this.wavelength[i]), (int)this.distance[i + 1] + 585, (int)(2250.0 - this.wavelength[i + 1]));
            g2.drawLine((int)this.distance[i] + 585, (int)(2250.0 - this.wavelength[i] + 10.0), (int)this.distance[i + 1] + 585, (int)(2250.0 - this.wavelength[i + 1] + 10.0));
        }
    }

    public void drawSquare(Graphics g, Double length, Double mass, double energy) {
        this.distance = new double[101];
        for (int i = 0; i < 101; ++i) {
            this.distance[i] = this.boxProportion[i] * length;
        }
        this.wavelength = new double[101];
        double firstpart = Math.pow(2.0 / length, 0.5);
        double secondpart = (double)this.n * Math.PI / length;
        for (int i = 0; i < 101; ++i) {
            double thirdpart = secondpart * this.distance[i];
            thirdpart = Math.sin(thirdpart);
            thirdpart /= 1.0E20;
            thirdpart = firstpart * thirdpart;
            this.wavelength[i] = Math.pow(thirdpart, 2.0);
            this.distance[i] = this.distance[i] * 100.0;
            this.wavelength[i] = this.wavelength[i] * 1.0E43;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(1.0, 0.1);
        switch (this.n) {
            case 1: {
                this.col = Color.BLUE;
                break;
            }
            case 2: {
                this.col = new Color(175, 3, 255);
                break;
            }
            case 3: {
                this.col = Color.ORANGE;
                break;
            }
            case 4: {
                this.col = Color.CYAN;
                break;
            }
            case 5: {
                this.col = Color.RED;
                break;
            }
            case 6: {
                this.col = Color.GREEN;
            }
        }
        g2.setColor(this.col);
        for (int i = 0; i < 100; ++i) {
            g2.drawLine((int)this.distance[i] + 585, (int)(2250.0 - this.wavelength[i]), (int)this.distance[i + 1] + 585, (int)(2250.0 - this.wavelength[i + 1]));
            g2.drawLine((int)this.distance[i] + 585, (int)(2250.0 - this.wavelength[i] + 10.0), (int)this.distance[i + 1] + 585, (int)(2250.0 - this.wavelength[i + 1] + 10.0));
        }
    }
}

