<?php

/*
	
	file: includes_socialfeed.php
	
	Attollos Technology
	v1.0
	© 2011 Attollos Technology Limited

*/

?>
<style>
body {
	font-family:Calibri, Helvetica, Arial, sans-serif;
	font-size:13px;
}
a {
	text-decoration:none;
	color:#0099FF;	
}
div.icon_tw {
	width:20px;
	height:15px;
	background:url(images/feed_twitter.png) no-repeat center;
	float:left;
	margin-right:4px;
	cursor:pointer;
}
div.icon_tw:first-child {
	margin-top:4px;
}
div.icon_fb {
	width:40px;
	height:29px;
	background:url(images/feed_facebook.png) no-repeat center;
	float:left;
	margin-right:4px;
	cursor:pointer;
}
div.text:first-child {
	margin-top:0px;
}
div.text {
	cursor:pointer;
	font-size:12px;
	width:145px;
	max-height:40px;
	margin-top:5px;
	margin-bottom:5px;
	text-overflow:elipsis;
	padding-bottom:5px;
	font-family:Helvatica, Calibri;
	overflow:hidden;
}
</style>

<?

function getTweets($username = false, $count = 6) {
  
  //Fetch data and process response
  $request = "http://api.twitter.com/1/statuses/user_timeline.rss?screen_name=$username";  //"http://search.twitter.com/search.atom?q=$username";
  $response = file_get_contents($request);
  $response = str_replace("twitter:", "", $response);
  $xml = simplexml_load_string($response);

  //Loop through specified amount of entries
  for($i=0;$i<$count;$i++)
  {
	  
    $id = $xml->entry[$i]->id;
    $id_parts = explode(":",$id);
    $tweet_id = array_pop($id_parts);

    $account_url = $xml->entry[$i]->author->uri;

    //$image_url = getXMLattribute($xml->entry[$i]->link[1],"href");

    $name = trim($xml->entry[$i]->author->name, ")");

    $name_parts = explode("(", $name);

    $real_name = trim(array_pop($name_parts));

    $screen_name = trim(array_pop($name_parts));

    $published_time = strtotime(trim(str_replace(array("T","Z")," ",$xml->entry[$i]->published)));

	
    $tweet_url = $xml->entry[$i]->link[0]->attributes();
	$tweet_url = $tweet_url['href'];

    $tweet = $xml->entry[$i]->content;
    $tweet = str_replace(array("<b>", "</b>"), "", $tweet);

    /*Now just create your HTML output */
	echo '<div class="icon_tw" onClick="window.open(\''. $tweet_url .'\',\'_blank\')"></div><div class="text">'. $tweet .'</div>';
  }
}
function twitify($str) {
    $search = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
                 "'<[/!]*?[^<>]*?>'si",          // Strip out HTML tags
                 "'([rn])[s]+'",                // Strip out white space
                 "'&(quot|#34);'i",                // Replace HTML entities
                 "'&(amp|#38);'i",
                 "'&(lt|#60);'i",
                 "'&(gt|#62);'i",
                 "'&(nbsp|#160);'i",
                 "'&(iexcl|#161);'i",
                 "'&(cent|#162);'i",
                 "'&(pound|#163);'i",
                 "'&(copy|#169);'i",
                 "'&#(d+);'e");                    // evaluate as php

$replace = array ("",
                 "",
                 "\1",
                 "\"",
                 "&",
                 "<",
                 ">",
                 " ",
                 chr(161),
                 chr(162),
                 chr(163),
                 chr(169),
                 "chr(\1)");
	
	return preg_replace($search, $replace, $str);
}


// James Robinson functions
function getNewTweets($username = false, $count = 6) {
  
  //Fetch data and process response
  $request = "http://api.twitter.com/1/statuses/user_timeline.rss?screen_name=$username";  //"http://search.twitter.com/search.atom?q=$username";
  $response = file_get_contents($request);
  $response = str_replace("twitter:", "", $response);
  $xml = simplexml_load_string($response);
	
	
  //Loop through specified amount of entries
  for($i=0;$i<$count;$i++) {
	  
	$title = $xml->channel->item[$i]->title;
	$tweet = explode(":",$title);
	$tweet = str_replace($tweet[0] .':', "", $title);
	
	$tweet_url = $xml->channel->item[$i]->link;


    /*Now just create your HTML output */
	echo '<div class="text" onClick="window.open(\''. $tweet_url .'\',\'_blank\')">'. process_tweet($tweet) .'</div>';
  }
}

function process_tweet($tweet) {
	$tweet = preg_replace('/((ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?)/', "<a href=\"$1\" target=\"_blank\">$1</a>", $tweet);  //<a target=_blank href=http://twitter.com/$1>@$1</a>
	$tweet = preg_replace('/[\@]+([A-Za-z0-9-_]+)/', "<a href=\"http://twitter.com/$1\" target=\"_blank\">@$1</a>", $tweet);
	$tweet = preg_replace('/(?:^| |\n)[\#]+([A-Za-z0-9-_]+)/', " <a href=\"http://search.twitter.com/search?q=&tag=$1&lang=all\" target=\"_blank\">#$1</a>", $tweet);
	//echo  '<br>'. $str .'<br>';
	
	return $tweet;	
}





// Print
getNewTweets('cybercrimeuk',6);

//echo '<div class="icon_tw" onClick="window.open(\'http://twitter.com/#Attollos_Devs\',\'_blank\')"></div><div class="text" style="font-size:22px;"><a href="http://twitter.com/#Attollos_Devs" target="_blank">@attollos devs</a></div>';
?>